*******************************************************************************
*                         680xx Grundprogramm sysmen                          *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                                Systemmen                                   *
*******************************************************************************


sysmen:                         * System Konfiguration
 lea systxt0(pc),a0
 bsr headaclr                   * berschrift
 cmp.b #3, uhrausw(a5)          * NVRAM Daten?
 beq.s sysmen2
 lea systxt00(pc),a0            * Text: Kein NVRAM vorhanden
 moveq #$21,d0
 moveq #5,d1
 move #191,d2
 bsr textprint                  * Befehlsliste
sysmen1:
 bsr csts                       * Zeichen von Tastatur da
 beq.s sysmen1                  * Nein, nochmal
 bra carset                     * zurck
sysmen2:
 lea idebuff+32(a5), a2
 move #23-1, d3
 lea systxt1(pc),a0
 moveq #$21,d0
 moveq #5,d1
 move #191,d2
 bsr textprint                  * Befehlsliste
 lea nvrbuff(a5), a0
 cmp #$a5c3, (a0)               * Pufferdaten gltig?
 bne.s sysmen3a                 * nein
 lea idebuff(a5), a1
 move #32-1, d3
sysmen2a:
 move.b (a0)+, (a1)+
 dbra d3, sysmen2a
 bra.s sysmen3
sysmen3a:
 lea idebuff(a5), a0
 bsr initnvrb                   * sonst default Werte
sysmen3:
 move #191, d2
 bsr syszloe                    * Zeile lschen
 lea ausbuf(a5), a0
 move.b #'%', (a0)
 clr.b 1(a0)
 move.b #$21, d0
 move #221, d1
 move #191, d2
 bsr textprint                  * '%' Ausgeben
 lea idebuff(a5), a1
 move.b 2(a1), d0
 lea ausbuf(a5), a0
 bsr print8b
 lea ausbuf(a5), a0
 move.b #$21, d0
 move #233, d1
 move #191, d2
 bsr textprint                  * DIP-Key Ausgabe
 move #171, d2
 bsr syszloe                    * Zeile lschen
 lea ausbuf(a5), a0
 addq.l #4, a1
 moveq #4-1, d3
 bsr sysmenw
 lea ausbuf(a5), a0
 move.b #$21, d0
 move #221, d1
 move #171, d2
 bsr textprint                  * Autoboot Ausgabe
 move #151, d2
 bsr syszloe                    * Zeile lschen
 lea ausbuf(a5), a0
 moveq #2-1, d3
 bsr sysmenw
 lea ausbuf(a5), a0
 move.b #$21, d0
 move #221, d1
 move #151, d2
 bsr textprint                  * SER Ausgabe
 move #131, d2
 bsr syszloe                    * Zeile lschen
 lea ausbuf(a5), a0
 moveq #6-1, d3
 bsr sysmenw
 lea ausbuf(a5), a0
 move.b #$21, d0
 move #221, d1
 move #131, d2
 bsr textprint                  * SER2 Kanal A Ausgabe
 move #111, d2
 bsr syszloe                    * Zeile lschen
 lea ausbuf(a5), a0
 moveq #6-1, d3
 bsr sysmenw
 lea ausbuf(a5), a0
 move.b #$21, d0
 move #221, d1
 move #111, d2
 bsr textprint                  * SER2 Kanal B Ausgabe
 move #91, d2
 bsr syszloe                    * Zeile lschen
 lea ausbuf(a5), a0
 lea idebuff(a5), a1
 clr.l d0
 move.b 3(a1), d0
 bsr print4d
 lea ausbuf(a5), a0
 move.b #$21, d0
 move #221, d1
 move #91, d2
 bsr textprint                  * Bootdelay Ausgabe
sysmen4:
 lea einbuf(a5),a0
 moveq #$21,d0
 moveq #5,d1
 moveq #4,d2
 moveq #1,d3                    * Nur ein Zeichen
 bsr textein                    * Befehl einlesen
 bcs carset                     * Abbruch
 move d5,d0
 bsr bucheck                    * In Grobuchstaben wandeln
 cmp.b #'A', d0
 beq sysmena                    * 'A' = DIP-Key
 cmp.b #'B', d0
 beq sysmenb                    * 'B' = Autoboot
 cmp.b #'C', d0
 beq sysmenc                    * 'C' = SER
 cmp.b #'D', d0
 beq sysmend                    * 'D' = SER2 Kanal A
 cmp.b #'E', d0
 beq sysmene                    * 'E' = SER2 Kanal B
 cmp.b #'F', d0
 beq sysmenf                    * 'F' = Bootdelay
 cmp.b #'M', d0
 beq carres                     * 'M' = Zurck
 cmp.b #'S', d0
 beq sysmens                    * 'S' = Speichern
 cmp.b #'Z', d0
 beq carres                     * 'Z' = Zurck
 bra.s sysmen4

sysmena:
 lea idebuff+2(a5), a1
 move #221,d6                   * X
 move #191,d2                   * Y
 moveq #9,d3                    * Anzahl der Zeichen maximal
 moveq #1-1,d7                  * Maximal 1 Zeichen
 bsr sysmenx
 bra sysmen3

sysmenb:
 lea idebuff+4(a5),a1           * Ziel fr Befehle
 move #221,d6                   * X
 move #171,d2                   * Y
 moveq #3,d3                    * Anzahl der Zeichen maximal
 moveq #4-1,d7                  * Maximal 4 Zeichen
 bsr sysmenx
 bra sysmen3

sysmenc:
 lea idebuff+8(a5),a1           * Ziel fr Befehle
 move #221,d6                   * X
 move #151,d2                   * Y
 moveq #3,d3                    * Anzahl der Zeichen maximal
 moveq #2-1,d7                  * Maximal 2 Zeichen
 bsr sysmenx
 bra sysmen3

sysmend:
 lea idebuff+10(a5),a1          * Ziel fr Befehle
 move #221,d6                   * X
 move #131,d2                   * Y
 moveq #3,d3                    * Anzahl der Zeichen maximal
 moveq #6-1,d7                  * Maximal 6 Zeichen
 bsr sysmenx
 bra sysmen3

sysmene:
 lea idebuff+16(a5),a1          * Ziel fr Befehle
 move #221,d6                   * X
 move #111,d2                   * Y
 moveq #3,d3                    * Anzahl der Zeichen maximal
 moveq #6-1,d7                  * Maximal 6 Zeichen
 bsr sysmenx
 bra sysmen3

sysmenf:
 lea idebuff+3(a5), a1
 move #221,d6                   * X
 move #91,d2                    * Y
 moveq #4,d3                    * Anzahl der Zeichen maximal
 moveq #1-1,d7                  * Maximal 1 Zeichen
 bsr sysmenx
 bra sysmen3

sysmens:
 lea idebuff(a5), a1
 lea nvrbuff(a5), a0
 move #32-1, d3
sysmens1:
 move.b (a1)+, (a0)+
 dbra d3, sysmens1
 lea nvrbuff(a5), a0
 bsr setsys
 lea nvrbuff(a5), a0
 move #$a5c3, (a0)
 bra carres

sysmenw:
 move.b #'$', (a0)+
 move.b (a1)+, d0
 bsr print2x
 move.b #' ', (a0)+
 dbra d3, sysmenw
 move.b #0, -1(a0)              * Endnull schreiben
 rts

sysmenx:
 lea einbuf(a5),a0
 moveq #$21,d0
 move d6,d1
 bsr textein                    * Zeichen lesen
 bcs.s sysmenx1                 * Ende
 tst d4
 beq.s sysmenx1                 * Ende
 lea einbuf(a5),a0
 bsr wertmfeh                   * Wert berechnen
 bcs.s sysmenx                  * Fehler, noch einmal eingeben
 move.b d0,(a1)+                * Wert ablegen
 add #48,d6                     * Neue Position
 dbra d7,sysmenx
sysmenx1:
 rts

syszloe:
 moveq #$21,d0                  * Schriftgre
 move #221,d1                   * X-Position
 bsr setprt                     * Werte einstellen
 bsr erapen                     * Auf Lschen
 moveq #%1010,d0                * Befehl fr Block
 moveq #20-1,d3                 * 20 Zeichen lschen
syszloe0:
 bsr cmd                        * Befehl an GDP
dbra d3,syszloe0
 bsr setpen
 rts

                                                         